const express = require('express');
const router = express.Router();
const db = require('../db');

// Pay a fee (simulate payment)
// POST /api/payments/pay
// body: { fee_id, amount, note }
router.post('/pay', async (req, res) => {
  try {
    const { fee_id, amount, note } = req.body;
    if (!fee_id || !amount) return res.status(400).json({ error: 'fee_id and amount required' });
    await db.markFeePaid(fee_id, amount, note || '');
    res.json({ ok: true });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: err.message });
  }
});

// List payments
router.get('/', async (req, res) => {
  try {
    const rows = await db.listPayments();
    res.json(rows);
  } catch (err) { res.status(500).json({ error: err.message }); }
});

module.exports = router;