const express = require('express');
const router = express.Router();
const db = require('../db');

// Create fee for a student
// POST /api/fees
// body: { student_id, month, year, amount }
router.post('/', async (req, res) => {
  try {
    const { student_id, month, year, amount } = req.body;
    if (!student_id || !month || !year || !amount) return res.status(400).json({ error: 'missing fields' });
    const id = await db.createFee(student_id, month, year, amount);
    res.json({ id });
  } catch (err) { res.status(500).json({ error: err.message }); }
});

// List fees for a student
router.get('/student/:student_id', async (req, res) => {
  try {
    const rows = await db.listFeesByStudent(req.params.student_id);
    res.json(rows);
  } catch (err) { res.status(500).json({ error: err.message }); }
});

// Get single fee
router.get('/:id', async (req, res) => {
  try{
    const f = await db.getFee(req.params.id);
    if (!f) return res.status(404).json({ error: 'Not found' });
    res.json(f);
  } catch (err) { res.status(500).json({ error: err.message }); }
});

module.exports = router;