# Syahriah Bulanan - Source Code (Demo)

Aplikasi demo "Syahriah Bulanan Anak Sekolah" menggunakan:
- Node.js + Express
- SQLite (file database)
- Frontend statis sederhana (Bootstrap + vanilla JS)

Fitur minimal:
- Kelola siswa (CRUD)
- Buat tagihan per bulan/tahun untuk siswa
- Tanda lunas (mencatat pembayaran)
- Export pembayaran ke CSV

Cara menjalankan:
1. Pastikan Node.js 18+ terpasang.
2. Simpan semua file proyek di satu folder, contoh: `syahriah-bulanan/`
3. Salin `.env.example` ke `.env` bila ingin mengatur PORT atau lokasi database.
4. Install dependensi:
   ```
   npm install
   ```
5. Jalankan:
   ```
   npm start
   ```
   atau saat development:
   ```
   npm run dev
   ```
6. Buka browser: http://localhost:3000

Lokasi endpoint API:
- GET /api/students
- POST /api/students
- GET /api/students/:id
- PUT /api/students/:id
- DELETE /api/students/:id
- POST /api/fees
- GET /api/fees/student/:student_id
- POST /api/payments/pay
- GET /api/payments
- GET /api/export/payments.csv

Membuat file ZIP (Linux / macOS):
- Pindah ke folder yang berisi semua file (satu level, bukan di dalam folder project):
  ```
  zip -r syahriah-bulanan.zip syahriah-bulan/ # atau nama folder Anda
  ```
Windows (PowerShell):
- Dari parent folder:
  ```
  Compress-Archive -Path .\syahriah-bulan\* -DestinationPath .\syahriah-bulan.zip
  ```

Catatan keamanan & pengembangan:
- Ini hanya demo; untuk produksi: gunakan autentikasi, validasi yang ketat, backup DB, HTTPS, dan proteksi CSRF.
- Untuk integrasi pembayaran nyata, tambahkan gateway (Midtrans/Xendit/Stripe) dan webhook verifikasi.
- Jika ingin, saya bisa:
  - menambahkan auth/admin,
  - migrasi ke Postgres/MySQL,
  - UI React/Vue,
  - atau menyiapkan file ZIP yang siap diunduh.
